/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.servlet.ActionBase;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.tree.NavigationTreeModel;
import com.ibm.hwmca.ui.bonsai.tree.NavigationTreeNode;
import com.ibm.hwmca.ui.bonsai.tree.TreeNodeCell;
import com.ibm.hwmca.ui.bonsai.util.GraphicsConstants;
import com.ibm.psw.wcl.components.tree.ExtendedTreeSelectionEvent;
import com.ibm.psw.wcl.components.tree.IExtendedTreeModel;
import com.ibm.psw.wcl.components.tree.IExtendedTreeSelectionListener;
import com.ibm.psw.wcl.components.tree.WTree;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.RendererInfo;
import com.ibm.psw.wcl.core.resource.UrlResource;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.skins.base.BaseTreeStyleInfo;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.tree.TreePath;

public class NavigationAction
extends ActionBase {
    private static final String TRACEMASK_T = "XBUINVAT";
    private static final String TRACEMASK_F = "XBUINVAF";
    private static final String TRACEMASK_D = "XBUINVAD";
    public static final String FRAME_NAME = "navigation_frame";
    public static final String FRAME_PATH = "frames['navigation_frame']";
    public static final String URI = "navigation.do";
    public static final String NAV_TREE_MAP = "bonsai_nav_tree_hashmap";
    private static final String REQUEST_TYPE_KEY = "request_type";
    private static final String EXTERIOR_SELECTION_REQUEST = "ext_sel";
    private static final String NODE_ID_KEY = "node_id";
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$tree$NavigationTreeNodeBean;
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$tree$NavigationTreeCellRenderer;

    public WPage perform(HttpServlet ctrlrServlet, HttpServletRequest request, HttpServletResponse response, RenderingContext rc) throws IOException, ServletException {
        HMCSession hmcSession = HMCSession.getHMCSession(request.getSession());
        UserObject userObj = UserObject.getUserObject(hmcSession);
        return this.singleTree(rc, request, userObj);
    }

    private WPage singleTree(RenderingContext rc, HttpServletRequest request, UserObject userObj) throws ServletException {
        ENavigationArea eNavigationArea = (ENavigationArea)userObj.getHMCSession().getSessionAttribute("ENavigationArea");
        WPage docContainer = null;
        try {
            String selectionId;
            String requestType;
            if (eNavigationArea == null) {
                this.setDefaultStyles(rc);
                eNavigationArea = new ENavigationArea(rc, userObj);
                userObj.getHMCSession().setSessionAttribute("ENavigationArea", eNavigationArea);
            }
            if ((requestType = request.getParameter(REQUEST_TYPE_KEY)) != null && requestType.equals(EXTERIOR_SELECTION_REQUEST) && (selectionId = request.getParameter(NODE_ID_KEY)) != null) {
                NavigationTreeModel model = (NavigationTreeModel)eNavigationArea.getTree_().getModel();
                model.setTreeSelection(selectionId, (AContext)rc);
            }
            docContainer = eNavigationArea.getNavigationDocument();
        }
        catch (Exception e) {
            throw new ServletException("Error creating wpage for navigation area.", (Throwable)e);
        }
        return docContainer;
    }

    public static String getSelectionUrl(String nodeId) {
        return "navigation.do?request_type=ext_sel&node_id=" + nodeId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ENavigationArea
    implements IExtendedTreeSelectionListener,
    Serializable {
        private WTree tree_ = null;
        private WPage docContainer_ = null;
        private NavigationTreeModel treeModel_ = null;

        public ENavigationArea(RenderingContext rc, UserObject userObj) throws IOException, ServletException {
            Trace.trace(NavigationAction.TRACEMASK_T, "-> ENavigationArea.ctor");
            try {
                this.docContainer_ = new WPage("NavigationActionPage");
                this.docContainer_.setID("NavigationActionDocumentContainer");
                AStyleInfo pageStyle = this.docContainer_.getStyleInfo(rc.getSkin());
                pageStyle.setStyleValue("page1", "background-color", (Object)"#e6e6e6");
                this.docContainer_.setStyleInfo(pageStyle);
                String className = this.getClass().getName();
                this.treeModel_ = new NavigationTreeModel(className, userObj);
                userObj.setModelVisible(NavigationAction.URI, className);
                BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
                treeManager.addTreePropertyListener(this.treeModel_);
                treeManager.getEventQueue().addEventQueueListener(this.treeModel_);
                this.tree_ = new WTree((IExtendedTreeModel)this.treeModel_, 254);
                this.tree_.addTreeSelectionListener((IExtendedTreeSelectionListener)this);
                this.tree_.setID("NavAreaTree");
                this.tree_.setRootVisible(false);
                this.tree_.setSelectionOnCollapse(true);
                this.tree_.setExpandsSelectedPaths(true);
                AStyleInfo styleInfo = this.tree_.getStyleInfo(rc.getSkin());
                if (styleInfo == null) {
                    styleInfo = new BaseTreeStyleInfo();
                    this.tree_.setStyleInfo(styleInfo);
                }
                styleInfo.setImageValue("IMG_TREE_COLLAPSED_JOINT", (Object)new UrlResource(GraphicsConstants.getNodeCollapsedIcon()), "20", "20");
                styleInfo.setImageValue("IMG_TREE_EXPANDED_JOINT", (Object)new UrlResource(GraphicsConstants.getNodeExpandedIcon()), "20", "20");
                styleInfo.setImageValue("IMG_TREE_COLLAPSED_JOINT_RTL", (Object)new UrlResource(GraphicsConstants.getNodeCollapsedIcon()), "20", "20");
                styleInfo.setImageValue("IMG_TREE_EXPANDED_JOINT_RTL", (Object)new UrlResource(GraphicsConstants.getNodeExpandedIcon()), "20", "20");
                styleInfo.setStyleValue("tre2", "visibility", (Object)"hidden");
                styleInfo.setStyleValue("tre3", "visibility", (Object)"hidden");
                styleInfo.setStyleValue("tre4", "visibility", (Object)"hidden");
                styleInfo.setStyleValue("tre6", "visibility", (Object)"hidden");
                styleInfo.setStyleValue("tre8", "visibility", (Object)"hidden");
                styleInfo.setStyleValue("tre9", "visibility", (Object)"hidden");
                styleInfo.setStyleValue("tre10", "visibility", (Object)"hidden");
                styleInfo.setStyleValue("tre6", "visibility", (Object)"hidden");
                styleInfo.setStyleValue("tre5", "background-image", styleInfo.getImageValue(rc, "IMG_TREE_FILLER_SPACER"));
                styleInfo.setStyleValue("tre11", "background-image", styleInfo.getImageValue(rc, "IMG_TREE_FILLER_SPACER"));
                styleInfo.setStyleValue("tre1", "background-image", styleInfo.getImageValue(rc, "IMG_TREE_FILLER_SPACER"));
                styleInfo.setStyleValue("tre7", "background-image", styleInfo.getImageValue(rc, "IMG_TREE_FILLER_SPACER"));
                this.tree_.setStyleInfo(styleInfo);
                try {
                    this.tree_.setCellRenderer(class$com$ibm$hwmca$ui$bonsai$tree$NavigationTreeNodeBean == null ? (class$com$ibm$hwmca$ui$bonsai$tree$NavigationTreeNodeBean = NavigationAction.class$("com.ibm.hwmca.ui.bonsai.tree.NavigationTreeNodeBean")) : class$com$ibm$hwmca$ui$bonsai$tree$NavigationTreeNodeBean, class$com$ibm$hwmca$ui$bonsai$tree$NavigationTreeCellRenderer == null ? (class$com$ibm$hwmca$ui$bonsai$tree$NavigationTreeCellRenderer = NavigationAction.class$("com.ibm.hwmca.ui.bonsai.tree.NavigationTreeCellRenderer")) : class$com$ibm$hwmca$ui$bonsai$tree$NavigationTreeCellRenderer, (AWCell)new TreeNodeCell(), RendererInfo.HTML_ALL);
                }
                catch (RendererException e) {
                    throw new ServletException("Error setting the cell renderer for tree.", (Throwable)e);
                }
                TreePath treePath = this.tree_.getPathForIndex(1);
                this.tree_.setSelectionPath(treePath, (AContext)rc);
                this.docContainer_.add((WComponent)this.tree_);
            }
            catch (Exception ex) {
                this.tree_ = null;
                throw new ServletException("Error creating WPage and contained objects in ENavigationArea.", (Throwable)ex);
            }
        }

        public WPage getNavigationDocument() throws IOException, ServletException {
            return this.docContainer_;
        }

        public void valueChanged(ExtendedTreeSelectionEvent e) {
            Trace.trace(NavigationAction.TRACEMASK_D, "<--> valueChanged(" + e + ")");
            try {
                String selectionId = ((NavigationTreeNode)e.getPath().getLastPathComponent()).getId();
                UserObject userObj = this.treeModel_.getUserObject();
                if (userObj.setTreeSelection(selectionId)) {
                    userObj.setActiveSelectionInTree(true);
                    UIRefreshManager.refresh(4, userObj.getHMCSession());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public WTree getTree_() {
            return this.tree_;
        }

        protected void finalize() {
            BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
            treeManager.removeTreePropertyListener(this.treeModel_);
            treeManager.getEventQueue().removeEventQueueListener(this.treeModel_);
        }
    }
}

